<div ng-controller="luhn">
    @include('luhn.template.filter', [
        'locations' => $locations
    ])
    @include('luhn.template.table')
    @include('luhn.template.modal')
</div>

@include('TEMPLATE.js.table')
<script>
    var $selectLocations = $('select[name="locations[]"]');
    $selectLocations.select2({
        placeholder: "Country"
    }).data('select2').$container.addClass("input-sm").css('padding', 0);

    $('.selectpicker').selectpicker({
        style: 'btn-default btn-sm'
    });

    $('.datepicker-range').datepicker({
        language: "ru",
        autoclose: true,
        todayHighlight: true,
        format: "yyyy/mm/dd"
    });

    app.controller('luhn', function($controller, $scope, $http, $location, $sce){
        $controller('table', {$scope: $scope});
        $scope.filter.client = $location.search().client;

        // Controller to URL
        $scope.$watch('filter.client', function (newVal, oldVal) {
            if(newVal && newVal != oldVal){
                $location.search("client", $scope.prepareClient(newVal), $location.search());
            }
        });

        // URL to controller
        $scope.$on('$locationChangeSuccess', function(event) {
            if($location.search().client != undefined){
                $scope.filter.client = $scope.prepareClient($location.search().client);
            }
        });

        $scope.unique = 0;
        $scope.reverse = true;
        $scope.sortField = 'id';
        $scope.modal = {};
        $scope.fields = [
            {'value': '', 'title': '<span class="glyphicon glyphicon-check"></span>', 'unsafe': true},
            {'value': '', 'title': 'Good'},
            {'value': 'number', 'title': 'Number'},
            {'value': '', 'title': 'Client'},
            {'value': 'location', 'title': 'Country'},
            {'value': 'datetime', 'title': 'Datetime'},
            {'value': '', 'title': 'Referer'},
            {'value': '', 'title': 'Comment', 'colspan': 2}
        ];
        $sce.trustAsHtml($scope.fields[0].titile);

        $scope.ifReset = function () {
            $('.selectpicker').val(null).selectpicker('refresh');
            $("#locations").val(null).trigger('change.select2');
            $('.select2-selection__clear').remove();
            $scope.unique = 0;
        };

        $scope.modal.open = function (number, valid, comment) {
            if(number){
                $scope.modal.number = number;
            }
            $scope.modal.valid = valid;
            $scope.modal.comment = comment;

            $('#myModal').modal('toggle');
        };

        $scope.modal.save = function () {
            var post = {
                id: $scope.modal.number,
                valid: $scope.modal.valid,
                comment: $scope.modal.comment
            };
            $http.post('/rest/luhn/unique/', post).then(function(data){
                $('#myModal').modal('toggle');
                $scope.apply();
            });
        };

        $scope.sendPost = function(){
            if($scope.post.client){
                $scope.post.client = $scope.prepareClient($scope.post.client);
            }

            $http.post('/rest/luhn/index/' + $scope.bigCurrentPage, $scope.post).then(function(data){
                if(data.hasOwnProperty('data')) {
                    $scope.data = data['data']['data'];
                    $scope.bigTotalItems = data['data']['total_items'];
                    $scope.itemsPerPage = data['data']['items_per_page'];
                    $scope.unique = data['data']['unique'];
                    if(data['data'].hasOwnProperty('current_page')){
                        $scope.bigCurrentPage = data['data']['current_page'];
                    }
                }else{
                    $scope.setDefaultValue();
                }
            });
        };

        $scope.prepareClient = function(str){
            var match = str.match('[a-fA-F0-9]{32}');
            if(match){
                return match[0];
            }else{
                return str;
            }
        }
    });
</script>